% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bsroc.R
\name{bsroc}
\alias{bsroc}
\title{bsroc}
\usage{
bsroc(m, data, level = c(0.05, 0.5, 0.95), link = "logit",
  title = "Bayesian SROC Curve", fpr.x = seq(0.01, 0.99, 0.01),
  xlim.bsroc = c(0, 1), ylim.bsroc = c(0, 1), lower.auc = 0,
  upper.auc = 0.99, col.fill.points = "blue", results.bauc = TRUE,
  results.bsroc = FALSE, plot.post.bauc = FALSE, binwidth.p = 1/30,
  scale.size.area = 10)
}
\arguments{
\item{m}{The model fitted.}

\item{data}{The data frame used to fit the model.}

\item{level}{Credibility levels of the predictive curve}

\item{link}{The link function used to fit the model. Possible values are \emph{logit}, \emph{cloglog} \emph{probit}.}

\item{title}{Optional parameter for setting a title in the plot.}

\item{fpr.x}{Grid of values where the conditionlal distribution is calculated.}

\item{xlim.bsroc}{Limits of the x-axis for the BSROC curve plot.}

\item{ylim.bsroc}{Limits of the y-axis for the BSROC curve plot.}

\item{lower.auc}{Lower limit of the AUC.}

\item{upper.auc}{Upper limit of the AUC.}

\item{col.fill.points}{Color used to fill points, default is blue.}

\item{results.bauc}{Print results of the Bayesian Area Under the Curve, default value is TRUE.}

\item{results.bsroc}{Print results of the Bayesian SROC curve, default value is FALSE.}

\item{plot.post.bauc}{The BSROC and the posterior of the BAUC are ploted in the same page, default is FALSE.}

\item{binwidth.p}{Histograms' binwidth, default is 1/30 range of the data.}

\item{scale.size.area}{Scale area for the ploted points, default = 10.}
}
\description{
This function plots the observe data in the ROC (Receiving Operating Charachteristics) space with the
Bayesian SROC (Summery ROC) curve. The predictive curves are approximated using a parametric model.
}
\examples{
## execute analysis
\dontrun{
data(glas)
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t,
re = "normal",
link = "logit",
nr.burnin = 1000,
nr.iterations = 10000,
nr.chains = 4,
r2jags = TRUE)

bsroc(m = glas.m1, data = glas.t)
}
}
\seealso{
\code{\link{metadiag}}.
}
\keyword{file}

