% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean-perch-data.R
\name{make_meas_object}
\alias{make_meas_object}
\title{Make measurement slice}
\usage{
make_meas_object(patho, specimen, test, quality, cause_list, sep_char = "_")
}
\arguments{
\item{patho}{A vector of pathogen names}

\item{specimen}{Specimen name}

\item{test}{Test name}

\item{quality}{Quality category: any of "BrS", "SS" or "GS".}

\item{cause_list}{The vector of potential latent status}

\item{sep_char}{a character string that separate the pathogen names and the
specimen-test pair; Default to \code{"_"}}
}
\value{
A list with measurement information
\itemize{
\item{\code{quality}} same as argument
\item{\code{patho}} same as argument
\item{\code{name_in_data}} the names used in the raw data to locate these measurements
\item{\code{template}} a mapping from \code{patho} to \code{cause_list}.
\code{NROW = length(cause_list)+1};
\code{NCOL = length(patho)}. This value is crucial in model fitting to determine
which measurements are informative of a particular category of latent status.
\item{\code{specimen}} same as argument
\item{\code{test}} same as argument
\item{\code{nm_spec_test}} paste \code{specimen} and \code{test} together
}
}
\description{
Wrap the information about a particular type of measurement, e.g., NPPCR.
NB: add example! copy some from the vignette file.
}
\examples{
make_meas_object(
patho = c("A","B","C","D","E","F"), 
specimen = "MBS",
test = "1",
quality = "BrS", 
cause_list = c("A","B","C","D","E"))

}
\seealso{
\code{\link[=make_template]{make_template()}}
}
\concept{data standardization functions}
