% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-etiology-regression.R
\name{plot_case_study}
\alias{plot_case_study}
\title{visualize the PERCH etiology regression with a continuous covariate}
\usage{
plot_case_study(
  DIR_NPLCM,
  stratum_bool = stratum_bool,
  bugs.dat = NULL,
  slice = 1,
  RES_NPLCM = NULL,
  do_plot = TRUE,
  do_rug = FALSE,
  return_metric = TRUE
)
}
\arguments{
\item{DIR_NPLCM}{File path to the folder containing posterior samples}

\item{stratum_bool}{integer; for this function, indicates which strata to plot}

\item{bugs.dat}{The posterior samples (loaded into the environment to save time) -> default is NULL}

\item{slice}{integer; specifies which slice of bronze-standard data to visualize; Default to 1.}

\item{RES_NPLCM}{pre-read res_nplcm; default to NULL.}

\item{do_plot}{TRUE for plotting}

\item{do_rug}{TRUE for plotting}

\item{return_metric}{TRUE for showing overall mean etiology, quantiles, s.d., and if \code{truth$Eti} is supplied,
coverage, bias, truth and integrated mean squared errors (IMSE).}
}
\value{
A figure of etiology regression curves and some marginal positive rate assessment of
model fit; See example for the legends.
}
\description{
This function is specifically designed for PERCH data, e.g.,
(NB: dealing with NoA, multiple-pathogen causes, other continuous covariates?
also there this function only plots the first slice - so generalization may be useful - give
users an option to choose slice s; currently default to the first slice.)
}
