#' Simulated data about morality and politics in Denmark
#'
#' This is a simulated counterpart of data presented
#' by Van Leeuwen and colleagues (2022) concerning
#' associations between moral dispositions (measured using the Morality As
#' Cooperation questionnaire, MAC; see Curry et al., 2019) and political
#' orientation.
#'
#' \tabular{lll}{
#'   \strong{sepa_soc_1} \tab \code{numeric} \tab Item 1 of the Policy Attitudes social (PA-social) scale.\cr
#'   \strong{sepa_soc_2} \tab \code{numeric} \tab Item 2 of the Policy Attitudes social (PA-social) scale.\cr
#'   \strong{sepa_soc_3} \tab \code{numeric} \tab Item 3 of the Policy Attitudes social (PA-social) scale.\cr
#'   \strong{sepa_soc_4} \tab \code{numeric} \tab Item 4 of the Policy Attitudes social (PA-social) scale.\cr
#'   \strong{sepa_soc_5} \tab \code{numeric} \tab Item 5 of the Policy Attitudes social (PA-social) scale.\cr
#'   \strong{sepa_eco_1} \tab \code{numeric} \tab Item 1 of the Policy Attitudes economic (PA-economic) scale.\cr
#'   \strong{sepa_eco_2} \tab \code{numeric} \tab Item 2 of the Policy Attitudes economic (PA-economic) scale.\cr
#'   \strong{sepa_eco_3} \tab \code{numeric} \tab Item 3 of the Policy Attitudes economic (PA-economic) scale.\cr
#'   \strong{sepa_eco_4} \tab \code{numeric} \tab Item 4 of the Policy Attitudes economic (PA-economic) scale.\cr
#'   \strong{sepa_eco_5} \tab \code{numeric} \tab Item 5 of the Policy Attitudes economic (PA-economic) scale.\cr
#'   \strong{fam_1} \tab \code{numeric} \tab Item 1 of the MAC (family subscale) scale.\cr
#'   \strong{fam_2} \tab \code{numeric} \tab Item 2 of the MAC (family subscale) scale.\cr
#'   \strong{fam_3} \tab \code{numeric} \tab Item 3 of the MAC (family subscale) scale.\cr
#'   \strong{grp_1} \tab \code{numeric} \tab Item 1 of the MAC (group subscale) scale.\cr
#'   \strong{grp_2} \tab \code{numeric} \tab Item 2 of the MAC (group subscale) scale.\cr
#'   \strong{grp_3} \tab \code{numeric} \tab Item 3 of the MAC (group subscale) scale.\cr
#'   \strong{rec_1} \tab \code{numeric} \tab Item 1 of the MAC (reciprocity subscale) scale.\cr
#'   \strong{rec_2} \tab \code{numeric} \tab Item 2 of the MAC (reciprocity subscale) scale.\cr
#'   \strong{rec_3} \tab \code{numeric} \tab Item 3 of the MAC (reciprocity subscale) scale.\cr
#'   \strong{her_1} \tab \code{numeric} \tab Item 1 of the MAC (heroism subscale) scale.\cr
#'   \strong{her_2} \tab \code{numeric} \tab Item 2 of the MAC (heroism subscale) scale.\cr
#'   \strong{her_3} \tab \code{numeric} \tab Item 3 of the MAC (heroism subscale) scale.\cr
#'   \strong{def_1} \tab \code{numeric} \tab Item 1 of the MAC (deference subscale) scale.\cr
#'   \strong{def_2} \tab \code{numeric} \tab Item 2 of the MAC (deference subscale) scale.\cr
#'   \strong{def_3} \tab \code{numeric} \tab Item 3 of the MAC (deference subscale) scale.\cr
#'   \strong{fai_1} \tab \code{numeric} \tab Item 1 of the MAC (fairness subscale) scale.\cr
#'   \strong{fai_2} \tab \code{numeric} \tab Item 2 of the MAC (fairness subscale) scale.\cr
#'   \strong{fai_3} \tab \code{numeric} \tab Item 3 of the MAC (fairness subscale) scale.\cr
#'   \strong{pro_1} \tab \code{numeric} \tab Item 1 of the MAC (property subscale) scale.\cr
#'   \strong{pro_2} \tab \code{numeric} \tab Item 2 of the MAC (property subscale) scale.\cr
#'   \strong{pro_3} \tab \code{numeric} \tab Item 3 of the MAC (property subscale) scale.\cr
#' }
#' @docType data
#' @keywords datasets
#' @name synthetic_dk
#' @usage data(synthetic_dk)
#' @references Van Leeuwen, F., Van Lissa, C. J., Papakonstantinou, T.,
#' Petersen, M., & Curry, O. S. (2022, May 25). Morality as Cooperation,
#' Politics as Conflict. <doi:10.31234/osf.io/wm6rk>
#'
#' Curry, O. S., Chesters, M. J., & Van Lissa, C. J. (2019). Mapping morality
#' with a compass: Testing the theory of 'morality-as-cooperation' with a new
#' questionnaire. Journal of Research in Personality, 78, 106-124.
#' @format A data frame with 552 rows and 31 variables.
NULL
