% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Draw a forest plot for a baggr model}
\usage{
forest_plot(
  bg,
  show = c("inputs", "posterior", "both", "covariates"),
  print = show,
  prob = 0.95,
  digits = 3,
  ...
)
}
\arguments{
\item{bg}{a \link{baggr} class object}

\item{show}{if \code{"inputs"}, then plotted points and lines
correspond to raw inputs for each group;
if \code{"posterior"} -- to posterior distribution;
you can also plot \code{"both"} inputs and posteriors;
if \code{"covariates"}, then fixed effect coefficients are plotted}

\item{print}{which values to print next to the plot: values of \code{"inputs"}
or \code{"posterior"} means?
(if \code{show="covariates"}, it must be \code{"posterior"})}

\item{prob}{width of the intervals (lines) for the plot}

\item{digits}{number of digits to display when printing out mean and SD
in the plot}

\item{...}{other arguments passed to \link{forestplot}}
}
\description{
The forest plot functionality in \emph{baggr} is a simple interface for
calling the \link{forestplot} function. By default the forest plot
displays raw (unpooled) estimates for groups and the treatment effect
estimate underneath. This behaviour can be modified to display pooled
group estimates.
}
\examples{
bg <- baggr(schools, iter = 500)
forest_plot(bg)
forest_plot(bg, show = "posterior", print = "inputs", digits = 2)

}
\seealso{
\link{forestplot} function and its vignette for examples;
\link{effect_plot} and \link{baggr_plot} for non-forest plots of baggr results
}
