% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.extract.R
\name{backbone.extract}
\alias{backbone.extract}
\title{Extracts the backbone of a weighted network using results from a null model}
\usage{
backbone.extract(positive, negative = NULL, alpha = 0.05)
}
\arguments{
\item{positive}{Matrix: proportion of times the projected matrix values were above the corresponding matrices generated by \link{hyperg}, \link{fdsm}, or \link{sdsm}.}

\item{negative}{Matrix: proportion of times the projected matrix values were below the corresponding matrices generated by \link{hyperg}, \link{fdsm}, or \link{sdsm}. If supplied, a signed backbone will be returned; if not supplied, a binary backbone will be returned. Default is set to NULL.}

\item{alpha}{Real: Precision of significance test (one-tailed if only the positive matrix supplied, two-tailed if positive and negative matrices supplied)}
}
\value{
backbone Matrix: Binary or signed adjacency matrix of backbone graph.
}
\description{
`backbone.extract` returns a binary or signed adjacency matrix
     containing the backbone that retains only the significant edges.
}
\examples{
probs <- sdsm(davis, 100)
bb <- backbone.extract(probs$positive, probs$negative)
}
