% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast2_output_to_ns.R
\name{parse_beast2_output_to_ns}
\alias{parse_beast2_output_to_ns}
\title{Put the info of a Nested Sampling run in a structure}
\usage{
parse_beast2_output_to_ns(output)
}
\arguments{
\item{output}{screen output}
}
\value{
a list with the following elements:
  \itemize{
    \item \code{marg_log_lik} the marginal log likelihood estimate
    \item \code{marg_log_lik_sd} the standard deviation around the estimate
  }
}
\description{
Put the info of a Nested Sampling run in a structure
}
\examples{
library(testthat)

ns <- parse_beast2_output_to_ns(
  output = create_test_ns_output()
)
expect_equal(ns$marg_log_lik, -141, tolerance = 0.2)
expect_equal(ns$marg_log_lik_sd, 1.60, tolerance = 0.5)
expect_equal(ns$ess, 5.49, tolerance = 0.2)
}
\seealso{
use \code{\link{create_test_ns_output}} to obtain
a test screen output.
}
\author{
Richèl J.C. Bilderbeek
}
