% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_availability_zone_group}
\alias{ec2_modify_availability_zone_group}
\title{Modify Availability Zone Group}
\usage{
ec2_modify_availability_zone_group(
  GroupName,
  OptInStatus,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{GroupName}{Character. The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.}

\item{OptInStatus}{Character. Indicates whether you are opted in to the Local Zone group or Wavelength Zone group.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Availability Zone Group
}
\section{GroupName}{

The name of the
Availability Zone group, Local Zone group, or Wavelength Zone
group.
}

\section{OptInStatus}{

Indicates whether you are opted in to the
Local Zone group or Wavelength Zone group. The only valid value is
\verb{opted-in}. You must contact \href{https://console.aws.amazon.com/support/home#/case/create\%3FissueType=customer-service\%26serviceCode=general-info\%26getting-started\%26categoryCode=using-aws\%26services}{AWS Support}
to opt out of a Local Zone group, or Wavelength Zone
group.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

