% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_bundle_tasks}
\alias{ec2_describe_bundle_tasks}
\title{Describe Bundle Tasks}
\usage{
ec2_describe_bundle_tasks(
  BundleId = NULL,
  Filter = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{BundleId}{List.   The bundle task IDs.  Default: Describes all your bundle tasks.  [optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Bundle Tasks
}
\section{BundleId}{


The bundle task IDs.

Default: Describes all your bundle tasks.
}

\section{Filter}{


The filters.
\itemize{
\item \code{bundle-id} - The ID of the bundle task.
\item \code{error-code} - If the task failed, the error code returned.
\item \code{error-message} - If the task failed, the error message returned.
\item \code{instance-id} - The ID of the instance.
\item \code{progress} - The level of task completion, as a percentage (for
example, 20\\%).
\item \code{s3-bucket} - The Amazon S3 bucket to store the AMI.
\item \code{s3-prefix} - The beginning of the AMI name.
\item \code{start-time} - The time the task started (for example,
2013-09-15T17:15:20.000Z).
\item \code{state} - The state of the task (\code{pending} \| \verb{waiting-for-shutdown}
\| \code{bundling} \| \code{storing} \| \code{cancelling} \| \code{complete} \|
\code{failed}).
\item \code{update-time} - The time of the most recent update for the task.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

