% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_peering_connection_options}
\alias{ec2_modify_vpc_peering_connection_options}
\title{Modify Vpc Peering Connection Options}
\usage{
ec2_modify_vpc_peering_connection_options(
  VpcPeeringConnectionId,
  AccepterPeeringConnectionOptions = NULL,
  DryRun = NULL,
  RequesterPeeringConnectionOptions = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcPeeringConnectionId}{String. The ID of the VPC peering connection.}

\item{AccepterPeeringConnectionOptions}{Object. The VPC peering connection options for the accepter VPC.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{RequesterPeeringConnectionOptions}{Object. The VPC peering connection options for the requester VPC.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpc Peering Connection Options
}
\section{VpcPeeringConnectionId}{

The ID of the VPC peering
connection.
}

\section{AccepterPeeringConnectionOptions}{

The VPC peering connection options for
the accepter VPC.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{RequesterPeeringConnectionOptions}{

The VPC peering connection
options for the requester VPC.
}

