% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_network_interface_attribute}
\alias{ec2_modify_network_interface_attribute}
\title{Modify Network Interface Attribute}
\usage{
ec2_modify_network_interface_attribute(
  NetworkInterfaceId,
  Attachment = NULL,
  Description = NULL,
  DryRun = NULL,
  SecurityGroupId = NULL,
  SourceDestCheck = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{Attachment}{Object. Information about the interface attachment.[optional]}

\item{Description}{Object. A description for the network interface.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{SecurityGroupId}{List. Changes the security groups for the network interface.[optional]}

\item{SourceDestCheck}{Object. Indicates whether source/destination checking is enabled.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified network interface attribute.
You can specify only one attribute at a time. You can use this action to
attach and detach security groups from an existing EC2
instance.
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{Attachment}{

Information about the interface
attachment. If modifying the \'delete on termination\' attribute, you
must specify the ID of the interface attachment.
}

\section{Description}{

A
description for the network interface.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{SecurityGroupId}{

Changes
the security groups for the network interface. The new set of groups you
specify replaces the current set. You must specify at least one group,
even if it\'s just the default security group in the VPC. You must
specify the ID of the security group, not the
name.
}

\section{SourceDestCheck}{

Indicates whether source/destination checking
is enabled. A value of \code{true} means checking is enabled, and \code{false}
means checking is disabled. This value must be \code{false} for a NAT
instance to perform NAT. For more information, see \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html}{NAT Instances}
in the \emph{Amazon Virtual Private Cloud User
Guide}.
}

