% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_export_transit_gateway_routes}
\alias{ec2_export_transit_gateway_routes}
\title{Export Transit Gateway Routes}
\usage{
ec2_export_transit_gateway_routes(
  TransitGatewayRouteTableId,
  S3Bucket,
  Filter = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the route table.}

\item{S3Bucket}{String. The name of the S3 bucket.}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Export Transit Gateway Routes
}
\section{TransitGatewayRouteTableId}{

The ID of the route
table.
}

\section{S3Bucket}{

The name of the S3
bucket.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{attachment.transit-gateway-attachment-id} - The id of the transit
gateway attachment.
\item \code{attachment.resource-id} - The resource id of the transit gateway
attachment.
\item \code{route-search.exact-match} - The exact match of the specified
filter.
\item \code{route-search.longest-prefix-match} - The longest prefix that
matches the route.
\item \code{route-search.subnet-of-match} - The routes with a subnet that match
the specified CIDR filter.
\item \code{route-search.supernet-of-match} - The routes with a CIDR that
encompass the CIDR filter. For example, if you have 10.0.1.0/29 and
10.0.1.0/31 routes in your route table and you specify
supernet-of-match as 10.0.1.0/30, then the result returns
10.0.1.0/29.
\item \code{state} - The state of the route (\code{active} \| \code{blackhole}).
\item \code{transit-gateway-route-destination-cidr-block} - The CIDR range.
\item \code{type} - The type of route (\code{propagated} \| \code{static}).
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

