% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_disable_transit_gateway_route_table_propagation}
\alias{ec2_disable_transit_gateway_route_table_propagation}
\title{Disable Transit Gateway Route Table Propagation}
\usage{
ec2_disable_transit_gateway_route_table_propagation(
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the propagation route table.}

\item{TransitGatewayAttachmentId}{String. The ID of the attachment.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Disables the specified resource attachment
from propagating routes to the specified propagation route
table.
}
\section{TransitGatewayRouteTableId}{

The ID of the propagation
route table.
}

\section{TransitGatewayAttachmentId}{

The ID of the
attachment.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

