% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_detach_network_interface}
\alias{ec2_detach_network_interface}
\title{Detach Network Interface}
\usage{
ec2_detach_network_interface(
  AttachmentId,
  DryRun = NULL,
  Force = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AttachmentId}{String. The ID of the attachment.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Force}{Logical.   Specifies whether to force a detachment.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Detaches a
network interface from an instance.
}
\section{AttachmentId}{

The ID of the
attachment.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Force}{


Specifies whether to force a detachment.
\itemize{
\item Use the \code{Force} parameter only as a last resort to detach a network
interface from a failed instance.
\item If you use the \code{Force} parameter to detach a network interface, you
might not be able to attach a different network interface to the
same index on the instance without first stopping and starting the
instance.
\item If you force the detachment of a network interface, the \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{instance metadata}
might not get updated. This means that the attributes associated
with the detached network interface might still be visible. The
instance metadata will get updated when you stop and start the
instance.
}
}

