% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_interface_permissions}
\alias{ec2_describe_network_interface_permissions}
\title{Describe Network Interface Permissions}
\usage{
ec2_describe_network_interface_permissions(
  NetworkInterfacePermissionId = NULL,
  Filter = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfacePermissionId}{List. One or more network interface permission IDs.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes
the permissions for your network interfaces.
}
\section{NetworkInterfacePermissionId}{

One or more network
interface permission IDs.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{network-interface-permission.network-interface-permission-id} - The
ID of the permission.
\item \code{network-interface-permission.network-interface-id} - The ID of the
network interface.
\item \code{network-interface-permission.aws-account-id} - The AWS account ID.
\item \code{network-interface-permission.aws-service} - The AWS service.
\item \code{network-interface-permission.permission} - The type of permission
(\code{INSTANCE-ATTACH} \| \code{EIP-ASSOCIATE}).
}
}

\section{MaxResults}{

The maximum number of results to return in
a single call. To retrieve the remaining results, make another call with
the returned \code{NextToken} value. If this parameter is not specified, up
to 50 results are returned by default.
}

