% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_traffic_mirror_filter_rule}
\alias{ec2_create_traffic_mirror_filter_rule}
\title{Create Traffic Mirror Filter Rule}
\usage{
ec2_create_traffic_mirror_filter_rule(
  TrafficMirrorFilterId,
  TrafficDirection,
  RuleNumber,
  RuleAction,
  DestinationCidrBlock,
  SourceCidrBlock,
  DestinationPortRange = NULL,
  SourcePortRange = NULL,
  Protocol = NULL,
  Description = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TrafficMirrorFilterId}{String. The ID of the filter that this rule is associated with.}

\item{TrafficDirection}{String. The type of traffic (\code{ingress} \| \code{egress}).}

\item{RuleNumber}{Integer. The number of the Traffic Mirror rule.}

\item{RuleAction}{String. The action to take (\code{accept} \| \code{reject}) on the filtered traffic.}

\item{DestinationCidrBlock}{String. The destination CIDR block to assign to the Traffic Mirror rule.}

\item{SourceCidrBlock}{String. The source CIDR block to assign to the Traffic Mirror rule.}

\item{DestinationPortRange}{Object. The destination port range.[optional]}

\item{SourcePortRange}{Object. The source port range.[optional]}

\item{Protocol}{Integer.   The protocol, for example UDP, to assign to the Traffic Mirror rule.[optional]}

\item{Description}{String. The description of the Traffic Mirror rule.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Traffic Mirror Filter Rule
}
\section{TrafficMirrorFilterId}{

The
ID of the filter that this rule is associated
with.
}

\section{TrafficDirection}{

The type of traffic (\code{ingress} \|
\code{egress}).
}

\section{RuleNumber}{

The number of the Traffic Mirror rule.
This number must be unique for each Traffic Mirror rule in a given
direction. The rules are processed in ascending order by rule
number.
}

\section{RuleAction}{

The action to take (\code{accept} \| \code{reject}) on
the filtered traffic.
}

\section{DestinationCidrBlock}{

The destination CIDR block to
assign to the Traffic Mirror rule.
}

\section{SourceCidrBlock}{

The source CIDR
block to assign to the Traffic Mirror rule.
}

\section{DestinationPortRange}{

The
destination port range.
}

\section{SourcePortRange}{

The source port
range.
}

\section{Protocol}{


The protocol, for example UDP, to assign to the Traffic Mirror rule.

For information about the protocol value, see \href{https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}
on the Internet Assigned Numbers Authority (IANA) website.
}

\section{Description}{

The description of the Traffic Mirror
rule.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

