% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_subnet}
\alias{ec2_create_subnet}
\title{Create Subnet}
\usage{
ec2_create_subnet(
  VpcId,
  CidrBlock,
  TagSpecification = NULL,
  AvailabilityZone = NULL,
  AvailabilityZoneId = NULL,
  Ipv6CidrBlock = NULL,
  OutpostArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{CidrBlock}{String. The IPv4 network range for the subnet, in CIDR notation.}

\item{TagSpecification}{List. The tags to assign to the subnet.[optional]}

\item{AvailabilityZone}{String.   The Availability Zone or Local Zone for the subnet.[optional]}

\item{AvailabilityZoneId}{String. The AZ ID or the Local Zone ID of the subnet.[optional]}

\item{Ipv6CidrBlock}{String. The IPv6 network range for the subnet, in CIDR notation.[optional]}

\item{OutpostArn}{String. The Amazon Resource Name (ARN) of the Outpost.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Subnet
}
\section{VpcId}{

The ID of the
VPC.
}

\section{CidrBlock}{

The IPv4 network range for the subnet, in CIDR
notation. For example, \verb{10.0.0.0/24}. We modify the specified CIDR block
to its canonical form; for example, if you specify \verb{100.68.0.18/18}, we
modify it to \verb{100.68.0.0/18}.
}

\section{TagSpecification}{

The tags to assign to
the subnet.
}

\section{AvailabilityZone}{


The Availability Zone or Local Zone for the subnet.

Default: AWS selects one for you. If you create more than one subnet in
your VPC, we do not necessarily select a different zone for each subnet.

To create a subnet in a Local Zone, set this value to the Local Zone ID,
for example \verb{us-west-2-lax-1a}. For information about the Regions that
support Local Zones, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions}{Available Regions}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

To create a subnet in an Outpost, set this value to the Availability
Zone for the Outpost and specify the Outpost ARN.
}

\section{AvailabilityZoneId}{

The AZ ID or the Local Zone ID of the
subnet.
}

\section{Ipv6CidrBlock}{

The IPv6 network range for the subnet, in
CIDR notation. The subnet size must use a /64 prefix
length.
}

\section{OutpostArn}{

The Amazon Resource Name (ARN) of the
Outpost. If you specify an Outpost ARN, you must also specify the
Availability Zone of the Outpost subnet.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

