% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_nat_gateway}
\alias{ec2_create_nat_gateway}
\title{Create Nat Gateway}
\usage{
ec2_create_nat_gateway(
  SubnetId,
  AllocationId,
  ClientToken = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SubnetId}{String. The subnet in which to create the NAT gateway.}

\item{AllocationId}{String. The allocation ID of an Elastic IP address to associate with the NAT gateway.}

\item{ClientToken}{String.   Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to assign to the NAT gateway.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a NAT gateway in the specified public
subnet. This action creates a network interface in the specified subnet
with a private IP address from the IP address range of the subnet.
Internet-bound traffic from a private subnet can be routed to the NAT
gateway, therefore enabling instances in the private subnet to connect
to the internet. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html}{NAT Gateways}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{SubnetId}{

The subnet in which to create the NAT
gateway.
}

\section{AllocationId}{

The allocation ID of an Elastic IP address
to associate with the NAT gateway. If the Elastic IP address is
associated with another resource, you must first disassociate
it.
}

\section{ClientToken}{


Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.

Constraint: Maximum 64 ASCII characters.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to assign to the
NAT gateway.
}

