% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_local_gateway_route_table_vpc_association}
\alias{ec2_create_local_gateway_route_table_vpc_association}
\title{Create Local Gateway Route Table Vpc Association}
\usage{
ec2_create_local_gateway_route_table_vpc_association(
  LocalGatewayRouteTableId,
  VpcId,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LocalGatewayRouteTableId}{String. The ID of the local gateway route table.}

\item{VpcId}{String. The ID of the VPC.}

\item{TagSpecification}{List. The tags to assign to the local gateway route table VPC association.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Associates the specified VPC
with the specified local gateway route table.
}
\section{LocalGatewayRouteTableId}{

The ID of the local gateway
route table.
}

\section{VpcId}{

The ID of the
VPC.
}

\section{TagSpecification}{

The tags to assign to the local gateway route
table VPC association.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

