% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_attach_classic_link_vpc}
\alias{ec2_attach_classic_link_vpc}
\title{Attach Classic Link Vpc}
\usage{
ec2_attach_classic_link_vpc(
  SecurityGroupId,
  InstanceId,
  VpcId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SecurityGroupId}{List. The ID of one or more of the VPC\'s security groups.}

\item{InstanceId}{String. The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.}

\item{VpcId}{String. The ID of a ClassicLink-enabled VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Attach Classic Link Vpc
}
\section{SecurityGroupId}{

The ID of one or more of the VPC\'s security
groups. You cannot specify security groups from a different
VPC.
}

\section{InstanceId}{

The ID of an EC2-Classic instance to link to
the ClassicLink-enabled VPC.
}

\section{VpcId}{

The ID of a
ClassicLink-enabled VPC.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

