% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_assign_private_ip_addresses}
\alias{ec2_assign_private_ip_addresses}
\title{Assign Private Ip Addresses}
\usage{
ec2_assign_private_ip_addresses(
  NetworkInterfaceId,
  AllowReassignment = NULL,
  PrivateIpAddress = NULL,
  SecondaryPrivateIpAddressCount = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{AllowReassignment}{Logical. Indicates whether to allow an IP address that is already assigned to another network interface or...[optional]}

\item{PrivateIpAddress}{List.   One or more IP addresses to be assigned as a secondary private IP address to the network interface....[optional]}

\item{SecondaryPrivateIpAddressCount}{Integer. The number of secondary IP addresses to assign to the network interface.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Assign Private Ip Addresses
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{AllowReassignment}{

Indicates whether to allow an IP address
that is already assigned to another network interface or instance to be
reassigned to the specified network interface.
}

\section{PrivateIpAddress}{


One or more IP addresses to be assigned as a secondary private IP
address to the network interface. You can\'t specify this parameter when
also specifying a number of secondary IP addresses.

If you don\'t specify an IP address, Amazon EC2 automatically selects an
IP address within the subnet range.
}

\section{SecondaryPrivateIpAddressCount}{

The number of secondary IP addresses to assign to
the network interface. You can\'t specify this parameter when also
specifying private IP addresses.
}

