% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_experiment_id_from_organism_id.R
\name{get_experiment_id_from_organism_id}
\alias{get_experiment_id_from_organism_id}
\title{Get experiment from organism}
\usage{
get_experiment_id_from_organism_id(
  organism_id,
  triplestore,
  description = FALSE
)
}
\arguments{
\item{organism_id}{Integer or a list of integer values.}

\item{triplestore}{Object of class triplestore_access which manages database
access.}

\item{description}{Logical value (TRUE/FALSE) to show/hide the description of
the experiment (FALSE by default).}
}
\value{
Data frame. Columns: "organism_id" "avida_experiment_id"
}
\description{
Get the experiment identifier and description from which a
digital organism is derived.
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single organism
get_experiment_id_from_organism_id(organism_id = 1, triplestore = avidaDB)

# More than one organism
get_experiment_id_from_organism_id(
  organism_id = c(1, 2, 3),
  triplestore = avidaDB
)

}
