% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transcriptome_id_from_phenotype_id.R
\name{get_transcriptome_id_from_phenotype_id}
\alias{get_transcriptome_id_from_phenotype_id}
\title{Get transcriptome from phenotype}
\usage{
get_transcriptome_id_from_phenotype_id(
  phenotype_id,
  seed_id = sample(1:1000, 1),
  transcriptome_seq = FALSE,
  transcriptome_pos = FALSE,
  phenotype_binary = FALSE
)
}
\arguments{
\item{phenotype_id}{Integer or list of integer values.}

\item{seed_id}{Integer (from 1 to 1000) or a vector of integer values. This
integer is used for starting the pseudo-random number generator that
represents the environment experiencing a digital organism. If seed_id value
is not specified, it returns data for a single randomly chosen seed_id value
(between 1 and 1000).}

\item{transcriptome_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{transcriptome_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "transcriptome_id",
"transcriptome_seq" (optional), "transcriptome_pos" (optional),
"phenotype_id", "phenotype_binary" (optional).
}
\description{
Get the transcriptome of a digital organism whose genome encodes
a specific phenotype for a list of seeds used for starting the pseudo-random
number generator (i.e., a set of environments).
}
\examples{

# Single phenotype
get_transcriptome_id_from_phenotype_id(phenotype_id = 1,
                                       transcriptome_seq = TRUE
)

# More than one phenotype at seed_1
get_transcriptome_id_from_phenotype_id(phenotype_id = c(1, 2), seed_id = 1)

# At seed_1 and seed_2
get_transcriptome_id_from_phenotype_id(
  phenotype_id = 1,
  seed_id = c(1, 2),
  transcriptome_pos = TRUE
)

}
