% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggautoimage.R
\name{ggautoimage}
\alias{ggautoimage}
\title{Display images using ggplot2}
\usage{
ggautoimage(x, y, z, f, proj = "none", parameters, orientation, lines, points,
  interp.args)
}
\arguments{
\item{x}{A numeric vector specifying the x coordinate locations.}

\item{y}{A numeric vector specifying the y coordinate locations.}

\item{z}{A numeric vector specifying the response for each (x,y)
location.}

\item{f}{A factor variable distinguishing between different facets,
i.e., the different images to be constructed.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{parameters}{A numeric vector specifying the values of the 
\code{parameters} argument in the 
\code{\link[mapproj]{mapproject}}.  This may be necessary when
\code{proj != "none"}.}

\item{orientation}{A vector \code{c(latitude,longitude,rotation)} 
which describes where the "North Pole" should be when computing 
the projection.  See \code{\link[mapproj]{mapproject}} for more
details.}

\item{lines}{A named list with components \code{x} and \code{y}
specifiying the locations to be connected by lines.  Distinct
lines should be separated by \code{NA} values.  See Details.}

\item{points}{A named list with components \code{x} and \code{y}
specifiying the locations to be plot points.}

\item{interp.args}{A named list with component matching the 
non \code{xyz} arguments of the 
\code{\link[MBA]{mba.surf}} function.  Used to customize
interpolation, when required.}
}
\description{
\code{ggautoimage} produces a sequence of images in a manner 
similar to \code{\link[autoimage]{autoimage}} using the 
\code{\link[ggplot2]{ggplot2}} package.
}
\details{
If \code{x} and \code{y} do not form a regular grid, then the 
\code{\link[MBA]{mba.surf}} function is used to
interpolate the locations onto a regular grid before constructing
the image.  This interpolation can be customized by passing
\code{interp.args} through \code{...}.  \code{interp.args} should
be a named list with components matching the non \code{xyz} 
arguments of the \code{\link[MBA]{mba.surf}} function.

When \code{proj != "none"}, the \code{\link[mapproj]{mapproject}} 
function is used to project the \code{x} and \code{y} coordinates. 
In that case, \code{proj} must correspond to one of the choices for
the \code{projection} argument in the 
\code{\link[mapproj]{mapproject}} function.  Necessary arguments
for \code{\link[mapproj]{mapproject}} should be provided through
the \code{parameters} and \code{orientation} arguments. 
See Examples or \code{\link[mapproj]{mapproject}} for more 
details.

Lines can be added to each image by providing the \code{lines}
argument.  In that case, \code{lines}
should be a list with components \code{x} and \code{y} 
specifying the locations to draw the lines.  If more than
one unconnected line should be drawn, then the coordinates
should be separated by NA.  e.g., to draw a line from (1, 1) to
(2, 2) and (3, 3) to (4, 4) (with a gap between the two lines), 
you would specify lines as 
lines(x = c(1:2, NA, 3:4), y =c(1:2, NA, 3:4)).  Also, see 
Examples.

Points can be added to each image by providing the \code{points}
argument.  In that case, \code{points}
should be a list with components \code{x} and \code{y} 
specifying the locations to draw the points.
}
\examples{
data(narccap)
# setup image for two days of narccap data
x <- rep(c(lon), 2)
y <- rep(c(lat), 2)
z <- c(tasmax[, , 1:2])
f <- factor(rep(c("day 1", "day 2"), each = length(lon)))
# load national borders
data("worldMapEnv", package = "maps")
lines <- maps::map("world", plot = FALSE)
# obtain us captial cities
data(us.cities, package = "maps")
cap <- us.cities[us.cities$capital == 2, ]
# convert to list format
points <- list(x = cap$lon, y = cap$lat)

\dontrun{
# basic images
ggautoimage(x, y, z, f)
# basic images with national borders and U.S. captials
ggautoimage(x, y, z, f, lines = lines, points = points)
# project coordinates with national borders and U.S. capitals
ggautoimage(x, y, z, f, lines = lines, points = points,
            proj = "bonne", parameters = 40)
# finer interpolation grid
ggautoimage(x, y, z, f, lines = lines, points = points,
            interp.args = list(no.X = 100, no.Y = 100))
}
}
\seealso{
\code{\link[autoimage]{autoimage}},
  \code{\link[fields]{image.plot}}, \code{\link[graphics]{axis}}
}
