% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate}
\alias{rotate}
\title{Rotate coordinates}
\usage{
rotate(coords, theta, pivot = c(0, 0))
}
\arguments{
\item{coords}{A 2-column matrix with the coordinates to be rotated.}

\item{theta}{The angle (in radians) to rotate the coordinates.}

\item{pivot}{The pivot point around which the coordinates are 
rotated. Default is c(0, 0), i.e., the origin.}
}
\description{
\code{rotate} rotates the coordinates by angle theta around a pivot
point.
}
\examples{
# coordinates to rotate
coords <- matrix(rnorm(20), ncol = 2)
# rotate coordinates pi/6 radians around the original
rcoords <- rotate(coords, pi/6)
#compare original coordinates to rotated coordinates
par(mfrow = c(1, 2))
plot(coords)
plot(rcoords)
}

