% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdraftma.R
\name{hdraftma}
\alias{hdraftma}
\title{High dimensional competing risk analysis using multivariate accelerated failure time model
        with mediation analysis.}
\usage{
hdraftma(m, n, survdur, event, sig, ths, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{sig}{Level of significance pre-determined by the user.}

\item{ths}{A numeric between 0 to 100.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws for the iterations.}

\item{data}{High dimensional data containing survival observations and high dimensional covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information including the competing risks the function
filters significant variables, allowing the user to fit multivariate AFT model. Further, it performs mediation
analysis among the significant variables and provides handful variables with their alpha.a values
which are mediator model exposure coefficients and beta.a coefficients.
}
\examples{
##
hdraftma(m=8,n=100,survdur="os",event="death2",sig=0.1,ths=0.02,b=10,d=10,data=hnscc2)
##
}
