% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins_chim.R
\name{bins_chim}
\alias{bins_chim}
\title{Chi-Square Binning
Chi-square binning, using the ChiMerge algorithm for bottom-up merging based on the chi-square test.}
\usage{
bins_chim(df, key_var, y_var, alpha)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}

\item{alpha}{Significance level(discretization);}
}
\value{
A data frame, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
Chi-Square Binning
Chi-square binning, using the ChiMerge algorithm for bottom-up merging based on the chi-square test.
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv" , package = "autoScorecard" ))
feature2 <- stats::na.omit( accepts[1:200,c(1,3,7:23)] )
all3 <- bins_chim( df = feature2 , key_var = "application_id", y_var = "bad_ind" , alpha=0.1 )
}
