% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootPredict.R
\name{bootPredict}
\alias{bootPredict}
\title{Bootstrap simulation for model prediction}
\usage{
bootPredict(fit, newdata, R = 100, type = "response", ...)
}
\arguments{
\item{fit}{An object of class lm or glm}

\item{newdata}{A data.frame}

\item{R}{Number of simulations. Note default R=100 is very low.}

\item{type}{he type of prediction required, see predict.glm. The default for glm models is on the scale of the response variable.
Thus for a binomial model the default predictions are predicted probabilities.}

\item{...}{Further arguments to be passed to boot::boot}
}
\value{
An object of class "data.frame"
}
\description{
Generate model predictions against a specified set of explanatory levels with bootstrapped confidence intervals.
}
\examples{
data(GBSG2,package="TH.data")
fit=glm(cens~horTh+pnodes,data=GBSG2,family="binomial")
newdata=expand.grid(horTh=factor(c(1,2),labels=c("no","yes")),pnodes=1:51)
bootPredict(fit,newdata)
library(survival)
fit=coxph(Surv(time,cens)~age+horTh+progrec+pnodes,data=GBSG2)
}
