
<!-- README.md is generated from README.Rmd. Please edit that file -->

# autoMFA

<!-- badges: start -->
<!-- badges: end -->

The goal of autoMFA is to fit the Mixture of Factor Analyzers (MFA)
model with as few inputs from users as possible. Specifically, it aims
to provide methods which can automatically determine the number of
components, g, and the number of factors, q, without them needing to be
specified by the user.

## Installation

You can install the released version of autoMFA from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("autoMFA")
```

## Example

This is a basic example which shows you how to fit an MFA model using
autoMFA, and how we can access the output structure:

``` r
library(autoMFA)
RNGversion('4.0.3'); set.seed(3)
MFA.fit <- AMFA(autoMFA::MFA_testdata,3,3, nkmeans = 3, nrandom = 3, itmax = 100)
#>   |                                                                              |                                                                      |   0%  |                                                                              |............                                                          |  17%  |                                                                              |.......................                                               |  33%  |                                                                              |...................................                                   |  50%  |                                                                              |...............................................                       |  67%  |                                                                              |..........................................................            |  83%  |                                                                              |......................................................................| 100%
#Looking at the fitted model parameters
MFA.fit$model
#> $pivec
#>            [,1]      [,2]      [,3]
#> [1,] 0.09444444 0.3333333 0.5722222
#> 
#> $B
#> , , 1
#> 
#>             [,1]
#> [1,]  0.51597871
#> [2,]  0.08739884
#> [3,] -0.10294159
#> 
#> , , 2
#> 
#>            [,1]
#> [1,] -0.5594624
#> [2,] -0.1989323
#> [3,]  0.7229942
#> 
#> , , 3
#> 
#>            [,1]
#> [1,]  0.5599214
#> [2,] -0.1553632
#> [3,]  0.5990317
#> 
#> 
#> $mu
#>             [,1]         [,2]        [,3]
#> [1,]  0.07634856 -0.006538803  2.94287575
#> [2,] -0.04333060  2.995101672  0.03491934
#> [3,]  2.96309540  0.006519381 -0.07965993
#> 
#> $D
#> , , 1
#> 
#>       [,1]      [,2]      [,3]
#> [1,] 0.005 0.0000000 0.0000000
#> [2,] 0.000 0.1018841 0.0000000
#> [3,] 0.000 0.0000000 0.1134614
#> 
#> , , 2
#> 
#>           [,1]      [,2]      [,3]
#> [1,] 0.1246119 0.0000000 0.0000000
#> [2,] 0.0000000 0.1124388 0.0000000
#> [3,] 0.0000000 0.0000000 0.0855889
#> 
#> , , 3
#> 
#>           [,1]      [,2]       [,3]
#> [1,] 0.1002322 0.0000000 0.00000000
#> [2,] 0.0000000 0.1000401 0.00000000
#> [3,] 0.0000000 0.0000000 0.09205569
#> 
#> 
#> $numFactors
#>      [,1] [,2] [,3]
#> [1,]    1    1    1
#How long did it take for each start to fit?
MFA.fit$diagnostics$times
#>   g              time status
#> 1 3 0.203135013580322     OK
#> 2 3 0.190057039260864     OK
#> 3 3 0.209331035614014     OK
#> 4 3 0.188174962997437     OK
#> 5 3 0.186160087585449     OK
#> 6 3 0.222768068313599     OK
#Lets look at the clusterings of the fitted model
MFA.fit$clustering$allocations
#>      [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8] [,9] [,10] [,11] [,12] [,13] [,14]
#> [1,]    3    3    3    3    3    3    3    3    3     3     3     3     3     3
#>      [,15] [,16] [,17] [,18] [,19] [,20] [,21] [,22] [,23] [,24] [,25] [,26]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,27] [,28] [,29] [,30] [,31] [,32] [,33] [,34] [,35] [,36] [,37] [,38]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,39] [,40] [,41] [,42] [,43] [,44] [,45] [,46] [,47] [,48] [,49] [,50]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,51] [,52] [,53] [,54] [,55] [,56] [,57] [,58] [,59] [,60] [,61] [,62]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,63] [,64] [,65] [,66] [,67] [,68] [,69] [,70] [,71] [,72] [,73] [,74]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,75] [,76] [,77] [,78] [,79] [,80] [,81] [,82] [,83] [,84] [,85] [,86]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,87] [,88] [,89] [,90] [,91] [,92] [,93] [,94] [,95] [,96] [,97] [,98]
#> [1,]     3     3     3     3     3     3     3     3     3     3     3     3
#>      [,99] [,100] [,101] [,102] [,103] [,104] [,105] [,106] [,107] [,108]
#> [1,]     3      3      3      3      3      3      3      3      3      3
#>      [,109] [,110] [,111] [,112] [,113] [,114] [,115] [,116] [,117] [,118]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,119] [,120] [,121] [,122] [,123] [,124] [,125] [,126] [,127] [,128]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,129] [,130] [,131] [,132] [,133] [,134] [,135] [,136] [,137] [,138]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,139] [,140] [,141] [,142] [,143] [,144] [,145] [,146] [,147] [,148]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,149] [,150] [,151] [,152] [,153] [,154] [,155] [,156] [,157] [,158]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,159] [,160] [,161] [,162] [,163] [,164] [,165] [,166] [,167] [,168]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,169] [,170] [,171] [,172] [,173] [,174] [,175] [,176] [,177] [,178]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,179] [,180] [,181] [,182] [,183] [,184] [,185] [,186] [,187] [,188]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,189] [,190] [,191] [,192] [,193] [,194] [,195] [,196] [,197] [,198]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,199] [,200] [,201] [,202] [,203] [,204] [,205] [,206] [,207] [,208]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,209] [,210] [,211] [,212] [,213] [,214] [,215] [,216] [,217] [,218]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,219] [,220] [,221] [,222] [,223] [,224] [,225] [,226] [,227] [,228]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,229] [,230] [,231] [,232] [,233] [,234] [,235] [,236] [,237] [,238]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,239] [,240] [,241] [,242] [,243] [,244] [,245] [,246] [,247] [,248]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,249] [,250] [,251] [,252] [,253] [,254] [,255] [,256] [,257] [,258]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,259] [,260] [,261] [,262] [,263] [,264] [,265] [,266] [,267] [,268]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,269] [,270] [,271] [,272] [,273] [,274] [,275] [,276] [,277] [,278]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,279] [,280] [,281] [,282] [,283] [,284] [,285] [,286] [,287] [,288]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,289] [,290] [,291] [,292] [,293] [,294] [,295] [,296] [,297] [,298]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,299] [,300] [,301] [,302] [,303] [,304] [,305] [,306] [,307] [,308]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,309] [,310] [,311] [,312] [,313] [,314] [,315] [,316] [,317] [,318]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,319] [,320] [,321] [,322] [,323] [,324] [,325] [,326] [,327] [,328]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,329] [,330] [,331] [,332] [,333] [,334] [,335] [,336] [,337] [,338]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,339] [,340] [,341] [,342] [,343] [,344] [,345] [,346] [,347] [,348]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,349] [,350] [,351] [,352] [,353] [,354] [,355] [,356] [,357] [,358]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,359] [,360] [,361] [,362] [,363] [,364] [,365] [,366] [,367] [,368]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,369] [,370] [,371] [,372] [,373] [,374] [,375] [,376] [,377] [,378]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,379] [,380] [,381] [,382] [,383] [,384] [,385] [,386] [,387] [,388]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,389] [,390] [,391] [,392] [,393] [,394] [,395] [,396] [,397] [,398]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,399] [,400] [,401] [,402] [,403] [,404] [,405] [,406] [,407] [,408]
#> [1,]      3      3      3      3      3      3      3      3      3      3
#>      [,409] [,410] [,411] [,412] [,413] [,414] [,415] [,416] [,417] [,418]
#> [1,]      3      3      3      3      2      2      2      2      2      2
#>      [,419] [,420] [,421] [,422] [,423] [,424] [,425] [,426] [,427] [,428]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,429] [,430] [,431] [,432] [,433] [,434] [,435] [,436] [,437] [,438]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,439] [,440] [,441] [,442] [,443] [,444] [,445] [,446] [,447] [,448]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,449] [,450] [,451] [,452] [,453] [,454] [,455] [,456] [,457] [,458]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,459] [,460] [,461] [,462] [,463] [,464] [,465] [,466] [,467] [,468]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,469] [,470] [,471] [,472] [,473] [,474] [,475] [,476] [,477] [,478]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,479] [,480] [,481] [,482] [,483] [,484] [,485] [,486] [,487] [,488]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,489] [,490] [,491] [,492] [,493] [,494] [,495] [,496] [,497] [,498]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,499] [,500] [,501] [,502] [,503] [,504] [,505] [,506] [,507] [,508]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,509] [,510] [,511] [,512] [,513] [,514] [,515] [,516] [,517] [,518]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,519] [,520] [,521] [,522] [,523] [,524] [,525] [,526] [,527] [,528]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,529] [,530] [,531] [,532] [,533] [,534] [,535] [,536] [,537] [,538]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,539] [,540] [,541] [,542] [,543] [,544] [,545] [,546] [,547] [,548]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,549] [,550] [,551] [,552] [,553] [,554] [,555] [,556] [,557] [,558]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,559] [,560] [,561] [,562] [,563] [,564] [,565] [,566] [,567] [,568]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,569] [,570] [,571] [,572] [,573] [,574] [,575] [,576] [,577] [,578]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,579] [,580] [,581] [,582] [,583] [,584] [,585] [,586] [,587] [,588]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,589] [,590] [,591] [,592] [,593] [,594] [,595] [,596] [,597] [,598]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,599] [,600] [,601] [,602] [,603] [,604] [,605] [,606] [,607] [,608]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,609] [,610] [,611] [,612] [,613] [,614] [,615] [,616] [,617] [,618]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,619] [,620] [,621] [,622] [,623] [,624] [,625] [,626] [,627] [,628]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,629] [,630] [,631] [,632] [,633] [,634] [,635] [,636] [,637] [,638]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,639] [,640] [,641] [,642] [,643] [,644] [,645] [,646] [,647] [,648]
#> [1,]      2      2      2      2      2      2      2      2      2      2
#>      [,649] [,650] [,651] [,652] [,653] [,654] [,655] [,656] [,657] [,658]
#> [1,]      2      2      2      2      1      1      1      1      1      1
#>      [,659] [,660] [,661] [,662] [,663] [,664] [,665] [,666] [,667] [,668]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,669] [,670] [,671] [,672] [,673] [,674] [,675] [,676] [,677] [,678]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,679] [,680] [,681] [,682] [,683] [,684] [,685] [,686] [,687] [,688]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,689] [,690] [,691] [,692] [,693] [,694] [,695] [,696] [,697] [,698]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,699] [,700] [,701] [,702] [,703] [,704] [,705] [,706] [,707] [,708]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,709] [,710] [,711] [,712] [,713] [,714] [,715] [,716] [,717] [,718]
#> [1,]      1      1      1      1      1      1      1      1      1      1
#>      [,719] [,720]
#> [1,]      1      1
```
