% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfa.R
\name{pfa}
\alias{pfa}
\title{Generate PFA Document from Object}
\usage{
pfa(object, name = NULL, version = NULL, doc = NULL, metadata = NULL,
  randseed = NULL, options = NULL, ...)
}
\arguments{
\item{object}{a model object for which a PFA document is desired}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose a valid PFA document
}
\description{
pfa is a generic function for generating valid PFA documents from the results 
of various model fitting functions. The function invokes particular methods 
which depend on the class of the first argument.
}
\examples{
# all the "pfa" methods found
methods("pfa")
}
\seealso{
\code{\link{pfa.lm}} \code{\link{pfa.glm}}
}
