% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holtwinters.R
\name{pfa.HoltWinters}
\alias{pfa.HoltWinters}
\title{PFA Formatting of Fitted Holt Winters Models}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{HoltWinters}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, ...)
}
\arguments{
\item{object}{an object of class "HoltWinters"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a Holt Winters model fit using HoltWinters()  
and returns a list-of-lists representing in valid PFA document 
that could be used for scoring
}
\examples{
model <- HoltWinters(co2)
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[stats]{HoltWinters}} \code{\link{extract_params.HoltWinters}}
}
