
<!-- 
<img src="https://raw.githubusercontent.com/aravind-j/augmentedRCBD/master/inst/extdata/augmentedRCBD.png" width="20%" />
-->

## `augmentedRCBD`: Analysis of Augmented Randomised Complete Block Designs <img src="https://raw.githubusercontent.com/aravind-j/augmentedRCBD/master/inst/extdata/augmentedRCBD.png" align="right" alt="logo" width="173" height = "200" style = "border: none; float: right;">

###### Version : [0.1.0](https://aravind-j.github.io/augmentedRCBD/); Copyright (C) 2015-2018: [ICAR-NBPGR](http://www.nbpgr.ernet.in/); License: [GPL-2|GPL-3](https://www.r-project.org/Licenses/)

##### *J. Aravind<sup>1</sup>, Mukesh Sankar S.<sup>2</sup>, Dhammaprakash P. Wankhede<sup>3</sup> and Vikender Kaur<sup>4</sup>*

1.  Division of Germplasm Conservation, ICAR-National Bureau of Plant
    Genetic Resources, New Delhi
2.  Division of Genetics, ICAR-Indian Agricultural Research Institute,
    New Delhi
3.  Division of Genomic Resources, ICAR-National Bureau of Plant Genetic
    Resources, New Delhi
4.  Division of Germplasm Evaluation, ICAR-National Bureau of Plant
    Genetic Resources, New Delhi

-----

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.0.2-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN\_Status\_Badge](https://www.r-pkg.org/badges/version-last-release/augmentedRCBD)](https://cran.r-project.org/package=augmentedRCBD)
<!-- [![rstudio mirror downloads](https://cranlogs.r-pkg.org/badges/grand-total/augmentedRCBD?color=green)](https://CRAN.R-project.org/package=augmentedRCBD) -->
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/aravind-j/augmentedRCBD) -->
[![develVersion](https://img.shields.io/badge/devel%20version-0.2.3.3-orange.svg)](https://github.com/aravind-j/augmentedRCBD)
<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/aravind-j/augmentedRCBD/total.svg)] -->
[![Project Status:
WIP](http://www.repostatus.org/badges/latest/wip.svg)](http://www.repostatus.org/#wip)
[![lifecycle](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://www.tidyverse.org/lifecycle/#experimental)
[![Last-changedate](https://img.shields.io/badge/last%20change-2018--07--08-yellowgreen.svg)](/commits/master)
<!-- [![Rdoc](http://www.rdocumentation.org/badges/version/augmentedRCBD)](http://www.rdocumentation.org/packages/augmentedRCBD) -->
<!-- [![Zenodo DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.841963.svg)](https://doi.org/10.5281/zenodo.841963) -->
[![Analytics](https://pro-pulsar-193905.appspot.com/UA-116716530-1/welcome-page)](https://github.com/aravind-j/google-analytics-beacon)

-----

## Description

Functions for analysis of data generated from experiments in augmented
randomised complete block design according to Federer, W.T. (1961)
[doi:10.2307/2527837](https://doi.org/10.2307/2527837). Computes
analysis of variance, adjusted means, descriptive statistics, genetic
variability statistics etc. Further includes data visualization and
report generation functions.

## Installation

### Install development version from Github

``` r
devtools::install_github("aravind-j/augmentedRCBD")
```

## What’s new

To know whats new in this version type:

``` r
news(package='augmentedRCBD')
```

## Links

<!-- [CRAN page](https://cran.r-project.org/package=augmentedRCBD) -->

[Github page](https://github.com/aravind-j/augmentedRCBD)

[Github website](https://aravind-j.github.io/augmentedRCBD/)

<!-- [Zenodo DOI](https://doi.org/10.5281/zenodo.841963) -->

## Citing `augmentedRCBD`

To cite the methods in the package use:

``` r
citation("augmentedRCBD")
```

``` 

To cite the R package 'augmentedRCBD' in publications use:

  J. Aravind, Mukesh Sankar S., Dhammaprakash P. Wankhede, and
  Vikender Kaur (2018).  augmentedRCBD: Analysis of Augmented
  Randomised Complete Block Designs. R package version 0.1.0,
  https://aravind-j.github.io/augmentedRCBD/.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {augmentedRCBD: Analysis of Augmented Randomised Complete Block Designs},
    author = {{Aravind J} and {Mukesh Sankar S} and {Dhammaprakash Pandhari Wankhede} and {Vikender Kaur}},
    note = {R package version 0.1.0},
    note = {https://aravind-j.github.io/augmentedRCBD/},
    year = {2018},
  }

This free and open-source software implements academic research by
the authors and co-workers. If you use it, please support the
project by citing the package.
```
