% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Deprecated}
\usage{
audit(
  object,
  data = NULL,
  y = NULL,
  predict.function = NULL,
  residual.function = NULL,
  label = NULL,
  predict_function = NULL,
  residual_function = NULL
)
}
\arguments{
\item{object}{An object containing a model or object of class explainer (see \code{\link[DALEX]{explain}}).}

\item{data}{Data.frame or matrix - data that will be used by further validation functions. If not provided, will be extracted from the model.}

\item{y}{Response vector that will be used by further validation functions. Some functions may require an integer vector containing binary labels with values 0,1.  If not provided, will be extracted from the model.}

\item{predict.function}{Function that takes two arguments: model and data. It should return a numeric vector with predictions.}

\item{residual.function}{Function that takes three arguments: model, data and response vector. It should return a numeric vector with model residuals for given data. If not provided, response residuals (\eqn{y-\hat{y}}) are calculated.}

\item{label}{Character - the name of the model. By default it's extracted from the 'class' attribute of the model.}

\item{predict_function}{Function that takes two arguments: model and data. It should return a numeric vector with predictions.}

\item{residual_function}{Function that takes three arguments: model, data and response vector. It should return a numeric vector with model residuals for given data. If not provided, response residuals (\eqn{y-\hat{y}}) are calculated.}
}
\value{
An object of class \code{explainer}.
}
\description{
The \code{audit()} function is deprecated, use \code{\link[DALEX]{explain}} from the \code{DALEX} package instead.
}
\examples{
data(titanic_imputed, package = "DALEX")

model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)
audit_glm <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

p_fun <- function(model, data) { predict(model, data, response = "link") }
audit_glm_newpred <- audit(model_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           predict.function = p_fun)


library(randomForest)
model_rf <- randomForest(Species ~ ., data=iris)
audit_rf <- audit(model_rf)

}
