% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_acf.R
\name{plot_acf}
\alias{plot_acf}
\alias{plotACF}
\title{Autocorrelation Function Plot}
\usage{
plot_acf(object, ..., variable = NULL, alpha = 0.95)

plotACF(object, ..., variable = NULL, alpha = 0.95)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{alpha}{Confidence level of the interval.}
}
\value{
A ggplot object.
}
\description{
Plot Autocorrelation Function of models' residuals.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

# plot results
plot(mr_lm, type = "acf")
plot_acf(mr_lm)


library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)
plot_acf(mr_lm, mr_rf)
plot(mr_lm, mr_rf, type="acf")


}
