% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_autocorrelation.R
\name{plot_autocorrelation}
\alias{plot_autocorrelation}
\alias{plotAutocorrelation}
\title{Autocorrelation of Residuals Plot}
\usage{
plot_autocorrelation(object, ..., variable = "_y_hat_", smooth = FALSE)

plotAutocorrelation(object, ..., variable, smooth = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).}

\item{smooth}{Logical, if TRUE smooth line will be added.}
}
\value{
A ggplot object.
}
\description{
Plot of i-th residual vs i+1-th residual.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

# plot results
plot_autocorrelation(mr_lm)
plot(mr_lm, type = "autocorrelation")
plot_autocorrelation(mr_lm, smooth = TRUE)
plot(mr_lm, type = "autocorrelation", smooth = TRUE)

}
