% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreROC.R
\name{scoreROC}
\alias{scoreROC}
\title{Area Under ROC Curve (AUC)}
\usage{
scoreROC(object)
}
\arguments{
\item{object}{An object of class ModelAudit.}
}
\value{
an object of class scoreAudit
}
\description{
Area Under Curve (AUC) for Receiver Operating Characteristic.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)
scoreROC(glm_au)

}
\seealso{
\code{\link{plotROC}}
}
