% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResidualBoxplot.R
\name{plotResidualBoxplot}
\alias{plotResidualBoxplot}
\title{Plot Boxplots of Residuals}
\usage{
plotResidualBoxplot(object, ...)
}
\arguments{
\item{object}{An object of class modelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}
}
\description{
A plot of residuals.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotResidual(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotResidualBoxplot(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
