% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelCorrelation.R
\name{plotModelCorrelation}
\alias{plotModelCorrelation}
\title{Model Correlation Plot}
\usage{
plotModelCorrelation(object, ..., values = "Fitted values")
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{values}{"Fitted values" or "Predicted response" for model fitted values or "Residuals" for residual values.}
}
\value{
ggplot object
}
\description{
Matrix of plots
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotModelCorrelation(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
