% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atus-data.R
\docType{data}
\name{atusact}
\alias{atusact}
\title{ATUS Respondent Daily Activity Summary (2003-2016)}
\format{A data frame with 2,094,140 observations on the following:
\describe{
 \item{tucaseid}{respondent id}
\item{tiercode}{activity tier code, in the format 'AABBCC', where 'AA' is the tier 1 activity code (1-18), 'BB' is the tier 2 activity code (0-99), and 'CC' is the numeric tier 3 activity code (0-99); see tier codebook}
\item{dur}{total duration (in minutes) spent over the course of the day by the respondent in the given tier code}
}
#' @source Aggregated from ATUS Activity data file from \url{https://www.bls.gov/tus/datafiles_0316.htm} with tier codebook at \url{https://www.bls.gov/tus/lexiconnoex0316.pdf}.}
\usage{
data(atusact)
}
\description{
A data frame with 2,094,140 observations on the following variables:
}
\examples{
data(atusact)
# example activity: sleeping
#          tier 1 code = 01 (personal care)
#          tier 2 code = 01 (sleeping)
#          tier 3 code = all

# this is a data frame with all individuals that did some amount of sleeping
# on their diary day
sleeping <- atusact[atusact$tiercode >= 10100 & atusact$tiercode < 10200,]

# how many did not sleep?
length(unique(atusact$tucaseid)) - length(unique(sleeping$tucaseid))

# example activity: doing homework (for a class towards a degree)
#          tier 1 code = 06
#          tier 2 code = 03
#          tier 3 code = 01

hw <- atusact[atusact$tiercode == 60301,]
hist(hw$dur)
summary(hw$dur)

}
\keyword{datasets}
