\name{getAllScores}
\alias{getAllScores}

\title{Compute similarity scores}

\description{
  This function computes similarity scores for two list of statistics which were previously computed by 'expressionStats'. 
  For each statistic which is available in both lists, four scores are calculated.  Two are based on correlation and the other two are based on the overlap of the histograms.
}

\usage{getAllScores(results.1, results.2)}

\arguments{
  \item{results.1}{
  A list of statistics generated by the function 'expressionStats'.
}
  \item{results.2}{
  A list of statistics generated by the function 'expressionStats'.
}
}


\value{
  A matrix with 4 columns and one row for each statistic which is available in both 'results.1' and 'results.2'.  
  Column one to four contain the different scores in this order: 'Overlap', 'Overlap shifted', 'Correlation', 'Correlation shifted'.
}

\author{
Robert Maier
}


\seealso{
\code{plotComparison}
\code{plotAll}
\code{expressionStats}
}

\examples{
data(GNW.s.expression.data)
data(GNW.s.network)
data(GNW.s.exp.group)
results <- expressionStats(GNW.s.expression.data[,1:200],
  GNW.s.network, GNW.s.exp.group)
results.p <- expressionStats(GNW.s.expression.data[,1:200],
  GNW.s.network, GNW.s.exp.group, permute.genes=TRUE)
scores <- getAllScores(results, results.p)

}
