% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/get_entities.R
\name{get_entities}
\alias{get_entities}
\title{Get information about entities from Axibase Time-Series Database.}
\usage{
get_entities(expression = "", active = "", tags = "*", limit = "",
  verbose = TRUE)
}
\arguments{
\item{expression}{Optional string argument.
Select entities matching particular name pattern and/or user-defined entity tags.
The syntax of the \code{expression} argument is explained in the package vignette.
Type \code{browseVignettes(package = "atsd")} to see the vignette.}

\item{active}{Optional string argument: "true" or "false".
Filter entities by \code{lastInsertTime}. If
\code{active = "true"},
only entities with positive lastInsertTime are included in the response.}

\item{tags}{Optional string argument.
User-defined entitiy tags to be included in the response.
By default, all the tags will be included.}

\item{limit}{Optional integer argument.
    If limit > 0, the response shows the top-N entities ordered by name.}

\item{verbose}{Optional boolean argument.
If \code{verbose = FALSE} then all console output will be suppressed.
By default, \code{verbose = TRUE}.}
}
\value{
A data frame.
    Each row of the data frame corresponds to an entity and its tags:
    \code{name},
    \code{enabled},
    \code{lastInsertTime}
    and user-defined entity tags as requested by the 'tags' argument.
    For more information look at the package vignette:
    \code{browseVignettes(package = "atsd")}.
}
\description{
This function fetches a list of entities from ATSD,
and convert it to a data frame.
}
\examples{
\dontrun{
# get all entities and include all their tags in the data frame
get_entities()

# get all active entities and include all their tags in the data frame
get_entities(active = "true")

# Get the top 2 entities whose 'name'  and user-defined entity tag, 'app',
# match to the expression. Include the tag, 'app', into response
# and exclude oter user-defined entity tags.
get_entities(expression = "name like 'nur*' and lower(tags.app) like '*hbase*'",
             tags = "app", limit = 2)
}
}
\seealso{
Visit
    \url{http://axibase.com/axibase-time-series-database/}
    for information about ATSD.
}

