% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomPubClient.R
\docType{class}
\name{AtomPubClient}
\alias{AtomPubClient}
\title{AtomPubClient class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an AtomPub client
}
\description{
This class models an AtomPub service client
}
\details{
AtomPubClient
}
\note{
Abstract class used internally for AtomPub (Atom Publishing Protocol) clients
}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, token, keyring_backend)}}{
   This method is to instantiate an AtomPub Client.

   The \code{keyring_backend} can be set to use a different backend for storing
   the Atom pub user token with \pkg{keyring} (Default value is 'env').

   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG"
   (for complete curl http calls logs)
 }
 \item{\code{getUser()}}{
   Retrieves user (if any specified).
 }
 \item{\code{getPwd()}}{
   Retrieves user password (if any user specified).
 }
 \item{\code{getToken()}}{
   Retrieves user token.
 }
 \item{\code{getServiceDocument()}}{
   Gets service document description. Unimplemented in abstract classes.
 }
 \item{\code{listCollections(pretty)}}{
   Lists the available collections. Use \code{pretty} to return a "data.frame" insteaf
   of a list.
 }
 \item{\code{getCollectionMembers(collectionId)}}{
   List members of a collection. Unimplemented in abstract classes.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Atom}
\keyword{Person}
