% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{awaitNext}
\alias{awaitNext}
\title{Wait for the next value from a channel or stream.}
\usage{
awaitNext(strm, or, err)
}
\arguments{
\item{strm}{A \link{channel} or \link{stream} object.}

\item{or}{This argument will be evaluated and returned in the case
the channel closes. If not specified, awaiting on a closed stream
will raise an error with message "StopIteration".}

\item{err}{A function to be called if the channel throws an error
condition.}
}
\value{
In the context of an \code{async} or \code{stream}, \code{awaitNext(x)}
returns the resolved value of a promise \code{x}, or stops with an
error.
}
\description{
\code{awaitNext} can be used within an \link{async} or \link{stream} coroutine.
When reached, \code{awaitNext} will register to receive the next element
from an async or a coroutine object.
}
