### This function is a component of astrochron: An R Package for Astrochronology
### Copyright (C) 2014 Stephen R. Meyers
###
###########################################################################
### readMatrix - (SRM: May 2, 2014)
###
### Read a matrix from file 
### The file can include any number of columns, each representing a different variable.
###########################################################################

readMatrix <- function (d=1,h="auto",output=1,genplot=T)
{

   cat("\n----- READ STRATIGRAPHIC SERIES FROM DATA FILE -----\n")
   cat("\nThe following options are selected:\n")
   if(d==0) cat(" * What type of column delimiter are you using?: Tab\n")
   if(d==1) cat(" * What type of column delimiter are you using?: Comma\n")
   if(h=="yes") cat(" * Does your file have column titles/headers?: yes\n")
   if(h=="no") cat(" * Does your file have column titles/headers?: no\n")
   if(h=="auto") cat(" * Does your file have column titles/headers?: auto detect\n")
   
   cat("\n  <PLEASE CHOOSE YOUR FILE>\n")
   
# pause so there is time to ouput text to screen.
   Sys.sleep(0.5)
### get file interactively
   filen <- file.choose()

  if(h=="no")
     {
       if(d == 0) {dat <- read.table (filen,header=F)}
       if(d == 1) {dat <- read.table (filen,header=F,sep=",")}
       xlab="Location"
       ylab="Value"
     }

  if(h=="yes")
     {
       if(d == 0) {dat <- read.table (filen,header=T)}
       if(d == 1) {dat <- read.table (filen,header=T,sep=",")}
       xlab=names(dat[1])
       ylab=names(dat[2])
     }

# auto detect column titles, for tab-delimited files
   if(h=="auto" && d == 0) 
      {
        dat <- read.table (filen,nrows=1,colClasses="character")
        titles=is.na(suppressWarnings(as.numeric(dat[1,1])))
# no column titles
        if (!titles )  
         {
           cat("\n * No column titles/headers detected\n")
           dat <- read.table (filen,header=F)
           xlab="Location"
           ylab="Value"
         }
# column titles        
        if (titles )  
         {
           cat("\n * Column titles/headers detected\n")
           dat <- read.table (filen,header=T)
           xlab=names(dat[1])
           ylab=names(dat[2]) 
         }
      }

# auto detect column titles, for csv files
   if(h=="auto" && d == 1) 
      {
        dat <- read.table (filen,nrows=1,colClasses="character",sep=",")
        titles=is.na(suppressWarnings(as.numeric(dat[1,1])))
# no column titles
        if (!titles )  
         {
           cat("\n * No column titles/headers detected\n")
           dat <- read.table (filen,header=F,sep=",")
           xlab="Location"
           ylab="Value"         
         }
# column titles        
        if (titles)  
         {
          cat("\n * Column titles/headers detected\n")
          dat <- read.table (filen,header=T,sep=",")
          xlab=names(dat[1])
          ylab=names(dat[2])    
         }
      }
     
   npts <- length(dat[,1]) 
   cat("\n * Number of rows=", npts,"\n")

### if we have two columns (time, variable), then sort, remove if NA in either column, and 
###  average duplicates if requested
   cols=length(dat)
   cat(" * Number of columns=",cols,"\n")
   
# determine if any missing entries (NA) still exist (this may be the case when cols>2)
     numNA=sum(is.na(dat))
     if(numNA > 0) 
       {
         cat("\n  WARNING:", numNA,"empty entries are still present in your data frame.\n")
       } 

if(genplot) 
  {
    nrow = ceiling(sqrt(cols-1))
    ncol = nrow
    par(mfrow = c(nrow, ncol))
    for (i in 1:cols) 
      {
        xlab = names(dat)[i]
        plotdat = subset(dat[,i], !(dat[,i] == "NA"))
        if(class(dat[,i]) == "numeric")
          {
            hist(plotdat,freq=F,xlab=xlab,main=""); lines(density(plotdat, bw="nrd0"),col="red")
          } 
        if(class(dat[,i]) != "numeric")
          {
        cat("\n  WARNING: column",i,"contains non-numeric values.  Will NOT generate a plot.\n")
          }
      }
  }
    
# output headers
   cat("\n * First 3 lines of data file:\n")
   print(head(dat,n=3L))
   
   if(output==1) return(as.matrix(dat))
   if(output==2) return(data.frame(dat))

### END function readMatrix
}