% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R, R/deprecated_se.R
\name{assert}
\alias{assert}
\alias{assert_}
\title{Raises error if predicate is FALSE in any columns selected}
\usage{
assert(data, predicate, ..., success_fun = success_continue,
  error_fun = error_stop)

assert_(data, predicate, ..., .dots, success_fun = success_continue,
  error_fun = error_stop)
}
\arguments{
\item{data}{A data frame}

\item{predicate}{A function that returns FALSE when violated}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}

\item{.dots}{Use assert_() to select columns using standard evaluation.}
}
\value{
By default, the \code{data} is returned if predicate assertion
        is TRUE and and error is thrown if not. If a non-default
        \code{success_fun} or \code{error_fun} is used, the return
        values of these function will be returned.
}
\description{
Meant for use in a data analysis pipeline, this function will
just return the data it's supplied if there are no FALSEs
when the predicate is applied to every element of the columns
indicated. If any element in any of the columns, when applied
to the predicate, is FALSE, then this function will raise an
error, effectively terminating the pipeline early.
}
\details{
For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

# returns mtcars
assert(mtcars, not_na, vs)

# return mtcars
assert(mtcars, not_na, mpg:carb)

library(magrittr)                    # for piping operator

mtcars \%>\%
  assert(in_set(c(0,1)), vs)
  # anything here will run

\dontrun{
mtcars \%>\%
  assert(in_set(c(1, 2, 3, 4, 6)), carb)
  # the assertion is untrue so
  # nothing here will run}

}
\seealso{
\code{\link{verify}} \code{\link{insist}}
         \code{\link{assert_rows}} \code{\link{insist_rows}}
}
