% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/has.R
\name{has_arg}
\alias{has_arg}
\title{Does the current call have an argument?}
\usage{
has_arg(x, fn = sys.function(sys.parent()))
}
\arguments{
\item{x}{Argument to check.}

\item{fn}{Function to find the argument in.}
}
\value{
\code{has_arg} reimplements \code{\link[methods]{hasArg}},
letting you choose the function to search in, and providing more
information on failure.
}
\description{
Checks to see if the current call has an argument with
the name given in the input.
}
\note{
There is currently no corresponding \code{assert_has_arg}
function, because evaluating in the correct call is hard.
}
\examples{
has_arg(x, mean.default)
has_arg(y, mean.default)
f <- function(...) has_arg(z)
f(z = 123)
f(123)
}
\seealso{
\code{\link[methods]{hasArg}}.
}

