% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-empty-scalar.R, R/is-empty-scalar.R
\name{assert_has_elements}
\alias{assert_has_elements}
\alias{assert_is_empty}
\alias{assert_is_non_empty}
\alias{assert_is_of_dimension}
\alias{assert_is_of_length}
\alias{assert_is_scalar}
\alias{has_elements}
\alias{is_empty}
\alias{is_non_empty}
\alias{is_of_dimension}
\alias{is_of_length}
\alias{is_scalar}
\title{Is the input empty/scalar?}
\usage{
assert_has_elements(x, n)

assert_is_empty(x, metric = c("length", "elements"))

assert_is_non_empty(x, metric = c("length", "elements"))

assert_is_of_dimension(x, n)

assert_is_of_length(x, n)

assert_is_scalar(x, metric = c("length", "elements"))

has_elements(x, n, .xname = get_name_in_parent(x))

is_empty(x, metric = c("length", "elements"),
  .xname = get_name_in_parent(x))

is_non_empty(x, metric = c("length", "elements"),
  .xname = get_name_in_parent(x))

is_of_dimension(x, n, .xname = get_name_in_parent(x))

is_of_length(x, n, .xname = get_name_in_parent(x))

is_scalar(x, metric = c("length", "elements"),
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{n}{Non-negative integer(s) of the expected length/number of elements/
lengths of dimensions.  See note.}

\item{metric}{A string. Should be length or the number of elements be used to
determine if the object is empty/non-empty/scalar?}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_empty} returns \code{TRUE} if the input has length
zero.  \code{is_scalar} returns \code{TRUE} if the input has length
one.  The \code{assert_*} functions return nothing but throw an
error if the corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input has length zero/one.
}
\note{
For \code{is_empty}, \code{is_non_empty} and \code{is_scalar}, \code{n}
should be an single integer representing either the expected length or the
expected number of elements in \code{x}.  For \code{is_of_dimension} \code{n}
should be a vector of integers representing the expected lengths of
dimensions.
}
\examples{
#' # is_of_length returns TRUE if the length of an object
# matches a specified value.
is_of_length(1:5, 5)
assert_is_of_length(1:5, 5)

# has_elements returns TRUE if an object has a specified
# number of elements.  This is usually the same thing.
has_elements(1:5, 5)
assert_has_elements(1:5, 5)

# Data frames and lists behave differently for length
# and number of elements.
d <- data.frame(x = 1:5, y = letters[1:5])
assert_is_of_length(d, 2)
assert_has_elements(d, 10)

l <- list(a = 1:5, b = list(b.a = 1:3, b.b = 1:7))
assert_is_of_length(l, 2)
assert_has_elements(l, 15)

# Functions always have length one, but may have lots of
# elements.
assert_is_of_length(var, 1)
assert_has_elements(var, 54)

# is_scalar is a shortcut for length one, or one elements.
assert_is_scalar(99)
assert_is_scalar("Multiple words in a single string are scalar.")
assert_is_scalar(NA)

# The two metrics can yield different results!
is_scalar(list(1:5))
is_scalar(list(1:5), "elements")
is_scalar(var)
is_scalar(var, "elements")

# Similarly, is_empty is a shortcut for length zero/zero elements.
assert_is_empty(NULL)
assert_is_empty(numeric())
assert_is_non_empty(1:10)
assert_is_non_empty(NA)

# is_of_dimension tests the lengths of all dimensions.
assert_is_of_dimension(d, c(5, 2))
assert_is_of_dimension(l, NULL)
}
\seealso{
\code{\link{length}}.
}

