% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-has-attributes.R, R/has-attributes.R
\name{assert_has_all_attributes}
\alias{assert_has_all_attributes}
\alias{assert_has_any_attributes}
\alias{has_attributes}
\title{Does the input have the specified attributes?}
\usage{
assert_has_all_attributes(x, attrs, severity = getOption("assertive.severity",
  "stop"))

assert_has_any_attributes(x, attrs, severity = getOption("assertive.severity",
  "stop"))

has_attributes(x, attrs, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{attrs}{Desired attributes.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{has_attributes} returns \code{TRUE} where \code{x} has
the attributes specified in \code{attrs}. \code{assert_has_terms} returns 
nothing but throws an error if \code{has_terms} is not \code{TRUE}.
}
\description{
Checks to see if the input has the specified attributes.
}
\examples{
# has_attributes is vectorized on attrs
has_attributes(sleep, c("class", "names", "row.names", "col.names"))

# You can check for any or all of these attributes to be present.
x <- structure(c(a = 1), b = 2)
assert_has_all_attributes(x, c("names", "b"))
assert_has_any_attributes(x, c("names", "not an attribute"))

# These examples should fail.
assertive.base::dont_stop({
assert_has_all_attributes(x, c("names", "not an attribute"))
})
}
\seealso{
\code{\link{has_any_attributes}} for checking that an object has
any attributes at all.
}

