% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_includes.R
\name{assert_excludes}
\alias{assert_excludes}
\title{Assert object does not include any illegal values}
\usage{
assert_excludes(
  x,
  illegal,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{illegal}{The prohibited elements to check for}

\item{msg}{A character string describing the error message if \code{x} includes any \code{illegal} elements}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} includes any \code{illegal} elements, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert x does not include illegal elements
}
\examples{
try({
assert_directory(system.file("package = assertions"))
assert_directory("foo") # Throws Error
})

}
\concept{assert_includes}
