% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VPCgraph.R
\name{VPC.graph}
\alias{VPC.graph}
\title{calculate percentiles of original data using bin-related weight
percentiles of simulated data with corresponding confidence interval}
\usage{
VPC.graph(orig.data, sim.data, N.timebin, N.sim, q.list = c(0.05, 0.5, 0.95),
  alpha = 0.05, X.name = "TIME", Y.name = "DV", main.title = NULL,
  opt.DV.point = FALSE, opt.DV.quantile.line = TRUE,
  opt.SIM.quantile.line = FALSE, opt.SIM.quantile.CI.area = TRUE,
  Y.min = NULL, Y.max = NULL, plot.flag = TRUE)
}
\arguments{
\item{orig.data}{NONMEM data}

\item{sim.data}{simulated data from NONMEM}

\item{N.timebin}{number of time bin}

\item{N.sim}{number of simulation}

\item{q.list}{list of quantiles for VPC plot}

\item{alpha}{significance level of CI for each quantile}

\item{X.name}{x label in VPC plot}

\item{Y.name}{y label in VPC plot}

\item{main.title}{title of plot}

\item{opt.DV.point}{option for drawing data points}

\item{opt.DV.quantile.line}{option for drawing quantiles of the original data}

\item{opt.SIM.quantile.line}{option for drawing quantiles of simulated data}

\item{opt.SIM.quantile.CI.area}{opeions for drawing confidence area of
quantiles for simulated data}

\item{Y.min}{minimum of y axis in VPC plot}

\item{Y.max}{maximum of y axis in VPC plot}

\item{plot.flag}{TRUE: drawing plot / FALSE: generate data for drawing plot}
}
\value{
plot or the values to draw plot
}
\description{
calculate percentiles of original data using bin-related weight
percentiles of simulated data with corresponding confidence interval
}
\examples{
data(origdata)
data(simdata)
VPC.graph(origdata,simdata,10,100)
}
\author{
Eun-Kyung Lee \email{lee.eunk@gmail.com}
}
\references{
new paper...
}

